<?php
/**
 * Bale Bot – v2.4
 * - Force-Join with callback-only popup (no extra chat message)
 * - Welcome message after successful recheck
 * - Admin panel (stats/broadcast/forward/block)
 * - Coin & Gold price queries
 * PHP >= 7.4
 */

date_default_timezone_set('Asia/Tehran');

/* ===============[ CONFIG ]=============== */
$token   = '914713472:cBcSHQCGgtL1IrbsHbw21IM3IZGfwqjzNEJaYVSp';   // توکن ربات بله
$adminId = 51116215;                         // آیدی عددی ادمین

// کانال(های) عضویت اجباری؛ ربات باید در آنها عضو باشد
$forceJoinChannels = ['@alaanchand'];        // نمونه: ['@alanchand']
// بررسی جویین فقط در پی‌وی انجام شود؟
$forceJoinOnlyInPrivate = true;

/* === APIs === */
$apiKey     = '1482706652:OKgqGoiu8wlYJbP@Api_ManagerRoBot';
$apiUrl     = 'https://api.fast-creat.ir/nobitex/v2?apikey=' . urlencode($apiKey);
$goldApiUrl = 'https://api.fast-creat.ir/gold?apikey=';
$apiKeygold = '1482706652:FpB0xDHYzM38NtW@Api_ManagerRoBot';

/* ===============[ Utils ]=============== */
function ensureLogsDir() { $d=__DIR__.'/logs'; if(!is_dir($d)) @mkdir($d,0777,true); }
ensureLogsDir();
function logx($n,$l){@file_put_contents(__DIR__."/logs/{$n}.log",date('Y-m-d H:i:s')." | ".$l.PHP_EOL,FILE_APPEND);}
function esc($s){return htmlspecialchars((string)$s,ENT_QUOTES|ENT_SUBSTITUTE,'UTF-8');}
function faNumToEn($t){$fa=['۰','۱','۲','۳','۴','۵','۶','۷','۸','۹'];$en=['0','1','2','3','4','5','6','7','8','9'];return str_replace($fa,$en,$t);}

/* ===============[ Storage ]=============== */
function saveUser($id){$f="users.txt";$u=file_exists($f)?file($f,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];if(!in_array($id,$u))file_put_contents($f,$id.PHP_EOL,FILE_APPEND);}
function addBlocked($id){$f="blocked.txt";$l=file_exists($f)?file($f,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];if(!in_array($id,$l))file_put_contents($f,$id.PHP_EOL,FILE_APPEND);}
function removeBlocked($id){$f="blocked.txt";if(!file_exists($f))return;$l=file($f,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES);$n=array_filter($l,fn($v)=>trim($v)!=trim($id));file_put_contents($f,implode(PHP_EOL,$n).(count($n)?PHP_EOL:''));}
function isBlocked($id){$f="blocked.txt";if(!file_exists($f))return false;$l=file($f,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES);return in_array((string)$id,$l);}
function setBotStatus($s){file_put_contents('bot_status.txt',$s==='enabled'?'enabled':'disabled');}
function getBotStatus(){if(!file_exists('bot_status.txt'))return'enabled';return trim(file_get_contents('bot_status.txt'))==='disabled'?'disabled':'enabled';}
function setPendingAction($a,$x){file_put_contents("pending_{$a}.txt",$x);}
function getPendingAction($a){$f="pending_{$a}.txt";if(!file_exists($f))return null;return trim(file_get_contents($f));}
function clearPendingAction($a){$f="pending_{$a}.txt";if(file_exists($f))unlink($f);}

/* ===============[ Bale API ]=============== */
function sendMessageBale($token,$chatId,$text,$replyMarkup=null){
    $d=['chat_id'=>$chatId,'text'=>$text,'parse_mode'=>'HTML'];
    if($replyMarkup)$d['reply_markup']=json_encode($replyMarkup,JSON_UNESCAPED_UNICODE);
    $u="https://tapi.bale.ai/bot$token/sendMessage?".http_build_query($d);
    $r=@file_get_contents($u);logx('send',"sendMessage -> {$u} -> {$r}");return $r;
}
function forwardBale($token,$chatId,$from_chat_id,$message_id){
    $d=['chat_id'=>$chatId,'from_chat_id'=>$from_chat_id,'message_id'=>$message_id];
    $u="https://tapi.bale.ai/bot$token/forwardMessage?".http_build_query($d);
    $r=@file_get_contents($u);logx('send',"forwardMessage -> {$u} -> {$r}");return $r;
}
function answerCallbackBale($token,$cid,$text='',$alert=false){
    $d=['callback_query_id'=>$cid,'text'=>$text,'show_alert'=>$alert?true:false];
    $u="https://tapi.bale.ai/bot$token/answerCallbackQuery?".http_build_query($d);
    $r=@file_get_contents($u);logx('send',"answerCallback -> {$u} -> {$r}");return $r;
}
function alertPopup($token,$cid,$text){return answerCallbackBale($token,$cid,$text,true);}

function normalizeChannelUsername($u){$c=ltrim(trim($u),'@');return '@'.$c;}
function getChatMemberBale($token,$chat_id,$user_id){
    $u="https://tapi.bale.ai/bot{$token}/getChatMember?".http_build_query(['chat_id'=>$chat_id,'user_id'=>$user_id]);
    $r=@file_get_contents($u);logx('join',"getChatMember {$chat_id} {$user_id} -> {$r}");return json_decode($r,true);
}
function isUserMemberOfChannel($token,$channel_username,$user_id){
    $chat=normalizeChannelUsername($channel_username);
    $res=getChatMemberBale($token,$chat,$user_id);
    if(!empty($res['ok']) && !empty($res['result']['status'])){
        $st=$res['result']['status'];
        return in_array($st,['member','administrator','creator'],true);
    }
    return false;
}

/* ===============[ Force-Join UI ]=============== */
function buildForceJoinKeyboard(array $channels): array {
    $rows=[];
    foreach($channels as $ch){$clean=ltrim($ch,'@');$rows[]=[[ 'text'=>"عضویت در @$clean", 'url'=>"https://ble.ir/{$clean}" ]];}
    $rows[]=[[ 'text'=>'✅ بررسی عضویت', 'callback_data'=>'recheck_join' ]];
    return ['inline_keyboard'=>$rows];
}

/* ===============[ Gold API ]=============== */
function getGoldPrice(){
    global $goldApiUrl,$apiKeygold;
    $u=$goldApiUrl.$apiKeygold;$r=@file_get_contents($u);
    if(!$r){logx('gold','no response');return false;}
    $j=json_decode($r,true);if(!$j || empty($j['ok'])){logx('gold','bad json/ok');return false;}
    foreach($j['result'] as $it){ if(isset($it['title']) && mb_strtolower($it['title'])==='طلای 18 عیار / 750'){ return $it['price'][0]; } }
    return false;
}

/* ===============[ Update Intake ]=============== */
$update = json_decode(file_get_contents('php://input'), true);
if(!$update) exit;

$message       = $update['message'] ?? null;
$callbackQuery = $update['callback_query'] ?? null;
if(!$message && !$callbackQuery) exit;

$chatId   = $message['chat']['id'] ?? ($callbackQuery['message']['chat']['id'] ?? null);
$fromId   = $message['from']['id'] ?? ($callbackQuery['from']['id'] ?? null);
$textRaw  = trim($message['text'] ?? '');
$chatType = $message['chat']['type'] ?? ($callbackQuery['message']['chat']['type'] ?? null);

$isCallbackRecheck = ($callbackQuery && (($callbackQuery['data'] ?? '') === 'recheck_join'));

/* ثبت کاربر/گروه */
if($message){
    if($chatType==='private' && isset($message['from']['id'])) saveUser($message['from']['id']);
    if($chatType==='group' || $chatType==='supergroup'){
        $gid=$message['chat']['id'];$gf="groups.txt";$gs=file_exists($gf)?file($gf,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];
        if(!in_array($gid,$gs)) file_put_contents($gf,$gid.PHP_EOL,FILE_APPEND);
    }
}

/* خاموشی ربات */
if(getBotStatus()==='disabled' && $fromId!=$adminId) exit;

/* نرمال‌سازی متن */
$text = mb_strtolower(faNumToEn($textRaw));

/* ===============[ FORCE JOIN GATE (messages only) ]=============== */
$shouldCheckJoin = !empty($forceJoinChannels) && ($forceJoinOnlyInPrivate ? $chatType==='private' : true);

/* مهم: روی کال‌بک recheck_join هیچ پیام جدیدی نفرست، فقط پاپ‌-آپ در بخش کال‌بک */
if($message && $shouldCheckJoin && $fromId){
    $ok=true;
    foreach($forceJoinChannels as $ch){ if(!isUserMemberOfChannel($token,$ch,$fromId)){ $ok=false; break; } }
    if(!$ok){
        $kb=buildForceJoinKeyboard($forceJoinChannels);
        $msg="برای استفاده از ربات، ابتدا در کانال زیر عضو شو و سپس «✅ بررسی عضویت» را بزن.";
        sendMessageBale($token,$chatId,$msg,$kb);
        exit;
    }
}

/* ===============[ CALLBACKS ]=============== */
if($callbackQuery){
    $cbData = $callbackQuery['data'] ?? '';
    $cbFrom = $callbackQuery['from']['id'] ?? 0;
    $cbId   = $callbackQuery['id'] ?? '';

    if($cbData==='recheck_join'){
        $ok=true;
        foreach($forceJoinChannels as $ch){ if(!isUserMemberOfChannel($token,$ch,$cbFrom)){ $ok=false; break; } }
        if($ok){
            // تأیید با پیام کوتاه و سپس خوش‌آمد
            answerCallbackBale($token,$cbId,"✅ عضویت تأیید شد.");
            $welcome = "خوش آمدی!\n"
                     . "برای استعلام قیمت، نام/نماد را بفرست:\n"
                     . "نمونه‌ها: btc — 2 eth — طلا — 5 طلا";
            sendMessageBale($token,$chatId,$welcome);
        }else{
            // فقط پاپ‌آپ؛ هیچ پیامی در چت ارسال نشود
            alertPopup($token,$cbId,"هنوز عضو کانال نشده‌ای. لطفاً عضو شو و دوباره «✅ بررسی عضویت» را بزن.");
        }
        exit;
    }

    // سایر کال‌بک‌ها فقط برای ادمین
    if($cbFrom != $adminId){ alertPopup($token,$cbId,"دسترسی ندارید."); exit; }

    $gf="groups.txt";$gs=file_exists($gf)?file($gf,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];

    switch($cbData){
        case 'stats':
            $users=file_exists("users.txt")?file("users.txt",FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];
            $msg="آمار ربات:\n"
               . "کاربران: ".count($users)."\n"
               . "گروه‌ها: ".count($gs);
            sendMessageBale($token,$chatId,$msg);
            answerCallbackBale($token,$cbId);
            break;

        case 'list_groups':
            $msg=(count($gs)===0)?"گروهی ثبت نشده است.":"لیست گروه‌ها (ID):\n".implode("\n",array_map(fn($g)=>"- ".esc($g),$gs));
            sendMessageBale($token,$chatId,$msg);
            answerCallbackBale($token,$cbId);
            break;

        case 'forward': setPendingAction($cbFrom,'forward'); sendMessageBale($token,$chatId,"پیام را ارسال/ریپلای/فوروارد کن تا برای همه ارسال شود."); answerCallbackBale($token,$cbId); break;
        case 'broadcast': setPendingAction($cbFrom,'broadcast'); sendMessageBale($token,$chatId,"متن ارسال همگانی را بفرست."); answerCallbackBale($token,$cbId); break;
        case 'block': setPendingAction($cbFrom,'block'); sendMessageBale($token,$chatId,"آیدی عددی کاربر را بفرست یا به پیام او ریپلای کن."); answerCallbackBale($token,$cbId); break;
        case 'unblock': setPendingAction($cbFrom,'unblock'); sendMessageBale($token,$chatId,"آیدی عددی کاربر را بفرست یا به پیام او ریپلای کن."); answerCallbackBale($token,$cbId); break;
        case 'disable': setBotStatus('disabled'); sendMessageBale($token,$chatId,"ربات خاموش شد (فقط ادمین دسترسی دارد)."); answerCallbackBale($token,$cbId); break;
        case 'enable': setBotStatus('enabled'); sendMessageBale($token,$chatId,"ربات روشن شد."); answerCallbackBale($token,$cbId); break;
        default: alertPopup($token,$cbId,"دستور نامشخص."); break;
    }
    exit;
}

/* ===============[ Commands – /start & /admin ]=============== */
if($message){
    if($chatType==='private' && isset($message['from']['id'])) saveUser($message['from']['id']);

    if(mb_strtolower($textRaw)==='/start'){
        $welcome=".
👋 خوش آمدی!
با این ربات می‌تونی قیمت لحظه‌ای طلا، سکه، ارز و کریپتو رو بگیری.\n"
                ."\n"
                ."🧭 راهنما:
• نام یا نماد رو بفرست (مثال: دلار | BTC | بیت‌ کوین )
• برای طلا بر حسب گرم: 2 طلا (قیمت ۲ گرم طلای ۱۸ عیار)
.";
        sendMessageBale($token,$chatId,$welcome);
        exit;
    }

    if($text==='/admin' && $fromId==$adminId){
        $kb=['inline_keyboard'=>[
            [['text'=>'آمار','callback_data'=>'stats']],
            [['text'=>'فوروارد','callback_data'=>'forward'],['text'=>'همگانی','callback_data'=>'broadcast']],
            [['text'=>'آنبلاک','callback_data'=>'unblock'],['text'=>'بلاک','callback_data'=>'block']],
            [['text'=>'خاموش','callback_data'=>'disable'],['text'=>'روشن','callback_data'=>'enable']],
            [['text'=>'لیست گروه‌ها','callback_data'=>'list_groups']],
        ]];
        sendMessageBale($token,$chatId,"پنل مدیریت:",$kb);
        exit;
    }
}

/* ===============[ Admin Pending Actions ]=============== */
function broadcastToUsers($token,$text){
    $us=file_exists("users.txt")?file("users.txt",FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];
    foreach($us as $u){ if(isBlocked($u)) continue; sendMessageBale($token,$u,$text); usleep(180000); }
}
function forwardToAll($token,$from_chat_id,$message_id){
    $us=file_exists("users.txt")?file("users.txt",FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];
    foreach($us as $u){ if(!isBlocked($u)) { forwardBale($token,$u,$from_chat_id,$message_id); usleep(150000);} }
    $gf="groups.txt";$gs=file_exists($gf)?file($gf,FILE_IGNORE_NEW_LINES|FILE_SKIP_EMPTY_LINES):[];
    foreach($gs as $g){ forwardBale($token,$g,$from_chat_id,$message_id); usleep(150000); }
}

if($message && $fromId==$adminId){
    $pending=getPendingAction($adminId);

    if($pending==='broadcast'){
        if(!empty($message['text'])){ broadcastToUsers($token,$message['text']); sendMessageBale($token,$chatId,"پیام همگانی ارسال شد."); }
        else{ sendMessageBale($token,$chatId,"لطفاً متن بفرست."); }
        clearPendingAction($adminId); exit;
    }

    if($pending==='forward'){
        if(!empty($message['message_id'])){ forwardToAll($token,$message['chat']['id'],$message['message_id']); sendMessageBale($token,$chatId,"پیام فوروارد شد."); }
        else{ sendMessageBale($token,$chatId,"پیام معتبر نیست. ارسال/ریپلای/فوروارد کن."); }
        clearPendingAction($adminId); exit;
    }

    if($pending==='block' || $pending==='unblock'){
        $target=null;
        if(!empty($message['reply_to_message'])) $target=$message['reply_to_message']['from']['id']??null;
        if(!$target){ $digits=preg_replace('/[^\d]/','',$message['text']??''); if($digits!=='') $target=(int)$digits; }
        if(!$target && !empty($message['forward_from'])) $target=$message['forward_from']['id']??null;

        if(!$target){ sendMessageBale($token,$chatId,"آیدی کاربر تشخیص داده نشد. آیدی عددی بفرست یا ریپلای کن."); exit; }

        if($pending==='block'){ addBlocked($target); sendMessageBale($token,$chatId,"کاربر {$target} بلاک شد."); }
        else { removeBlocked($target); sendMessageBale($token,$chatId,"کاربر {$target} آنبلاک شد."); }

        clearPendingAction($adminId); exit;
    }
}

/* ===============[ Fetch Coins ]=============== */
$response=@file_get_contents($apiUrl);
$data=json_decode($response,true);
if(!isset($data['result']) || !is_array($data['result'])){
    if($message && $chatType==='private'){ sendMessageBale($token,$chatId,"مشکلی در دریافت داده از API پیش آمد. کمی بعد تلاش کن."); }
    exit;
}

$coins=[];
foreach($data['result'] as $sym=>$coinData){
    $coins[mb_strtolower($sym)]=$coinData;
    $coins[mb_strtolower($coinData['name'])]=$coinData;
}

$manualAliases=[
    'طلا'=>'gold','دلار'=>'tether','تتر'=>'tether','تون'=>'ton','ترون'=>'trx','اتریوم'=>'eth','اتریوم کلاسیک'=>'etc',
    'بیت کوین'=>'btc','بیت کوین کش'=>'bch','دوج کوین'=>'doge','پالیگان'=>'pol','استلار'=>'xlm','کاردانو'=>'ada',
    'چین لینک'=>'link','یونی سواپ'=>'uni','دای'=>'dai','پولکادات'=>'dot','آوه'=>'aave','اکسی'=>'axs',
    'دیسنترالند'=>'mana','سندباکس'=>'sand','آوالانچ'=>'avax','یو اس دی کوین'=>'usdc','استپن'=>'gmt','میکر'=>'mkr',
    'سولانا'=>'sol','اتم'=>'atom','گراف'=>'grt','بت'=>'bat','نیر پروتکل'=>'near','ایپ کوین'=>'ape','کوانت'=>'qnt',
    'چیلیز'=>'chz','مونرو'=>'xmr','الگورند'=>'algo','هدرا'=>'hbar','وان ایچ نتورک'=>'1inch','یرن فایننس'=>'yfi',
    'فلو'=>'flow','سینتتیکس'=>'snx','انجین کوین'=>'enj','کرو دائو توکن'=>'crv','فایل کوین'=>'fil','رپد بیت کوین'=>'wbtc',
    'لیدو دائو'=>'ldo','دی وای دی ایکس'=>'dydx','اپتاس'=>'apt','مسک نتورک'=>'mask','کامپاند'=>'comp','بالانسر'=>'bal',
    'لوپرینگ'=>'lrc','لایوپیر'=>'lpt','اتریوم نیم سرویس'=>'ens','سوشی سواپ'=>'sushi','ای پی آی 3'=>'api3','هارمونی'=>'one',
    'گولم'=>'glm','پیمان'=>'pmn','دائو میکر'=>'dao','سیویک'=>'cvc','نومریر'=>'nmr','استورج'=>'storj','استاتوس'=>'snt',
    'آراگون'=>'ant','زیرو ایکس'=>'zrx','اسموث لاو پوشن'=>'slp','مولتی ورس ایکس'=>'egld','ایموتبل ایکس'=>'imx','بلر'=>'blur',
    '100 هزار فلوکی'=>'100k_floki','1 میلیارد بیبی دوج'=>'1b_babydoge','1 میلیون ایپ ان اف تی'=>'1m_nft','1 میلیون بیت تورنت'=>'1m_btt',
    'ترشولد'=>'t','سلر نتورک'=>'celr','اربیتروم'=>'arb','مجیک'=>'magic','جی ام اکس'=>'gmx','بند'=>'band','کانوکس فایننس'=>'cvx',
    'اس اس وی نتوورک'=>'ssv','مرژبل دیتا'=>'mdt','او ام جی نتورک'=>'omg','ورلد کوین'=>'wld','رادیانت کپیتال'=>'rdnt',
    'جاست'=>'jst','بیکو'=>'bico','وو نتورک'=>'woo','اسکیل'=>'skl','گلکس'=>'gal','سینگولاریتی نت'=>'agix','فچ ای آی'=>'fet','فانتوم'=>'s',
];

/* ===============[ Queries ]=============== */
// طلا n گرم
if(preg_match('/^(\d+)\s*(طلا|gold)$/iu',trim($text),$m)){
    $amount=(int)$m[1]; $gp=getGoldPrice();
    if($gp===false){ sendMessageBale($token,$chatId,"نتوانستم قیمت طلا را بگیرم. دوباره تلاش کن."); }
    else{ $t=$gp/10; $total=$amount*$t; sendMessageBale($token,$chatId,"قیمت طلای ۱۸ عیار برای {$amount} گرم:\n".number_format($total)." تومان"); }
    exit;
}
// طلا
if($text==='طلا' || $text==='gold'){
    $gp=getGoldPrice();
    if($gp===false){ sendMessageBale($token,$chatId,"نتوانستم قیمت طلا را بگیرم. دوباره تلاش کن."); }
    else{ $t=$gp/10; sendMessageBale($token,$chatId,"قیمت لحظه‌ای طلای ۱۸ عیار:\n".number_format($t)." تومان"); }
    exit;
}

// ارز: [amount]? [symbolOrName]
if(preg_match('/^\s*([\d.]+)?\s*([\p{L}0-9_]+)\s*$/u',$text,$mm)){
    $amount=(isset($mm[1]) && $mm[1]!=='')?floatval($mm[1]):1;
    $key=mb_strtolower($mm[2]); $map=$manualAliases[$key]??$key; $coin=$coins[$map]??null;
    if($coin){
        $usd=(float)$coin['usdt']; $irr=(float)$coin['irr']; $chg=(float)$coin['dayChange'];
        $profitUsd=$amount*$usd*($chg/100); $profitIrr=$amount*$irr*($chg/100); $dt=date('Y/m/d | H:i:s');
        $symbol=null; foreach($data['result'] as $sym=>$c){ if($c===$coin){ $symbol=strtoupper($sym); break; } } if(!$symbol)$symbol=strtoupper($map);
        $msg=rtrim(rtrim(number_format($amount,2),'0'),'.')." {$symbol}\n"
            ."$".number_format($amount*$usd,2)."\n"
            .number_format($amount*$irr)." تومان\n\n"
            .($chg>=0?"🟢":"🔴")." تغییرات 24ساعت: ".number_format($chg,2)."%\n"
            .($chg>=0?"🔺 سود":"🔻 ضرر").": ".number_format($profitUsd,6)." $ / ".number_format($profitIrr)." تومان\n\n"
            .$dt;
        sendMessageBale($token,$chatId,$msg); exit;
    }
}

// راهنمای کوتاه در PV
if(($message && $chatType==='private') && $textRaw!==''){
    sendMessageBale($token,$chatId,"متوجه «".esc($textRaw)."» نشدم.\n"
        ."نام/نماد یا «عدد + ارز» را این‌گونه بفرست:\n"
        ."btc — 2 eth — طلا — 5 طلا");
}
